import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import javax.microedition.io.*;
import java.io.*;

public class HttpPost extends MIDlet implements CommandListener  {
  // Valeur par dfaut de l'URL 
  private static String myURL = "http://j2me.netinnovations.fr/livre/HttpPost.asp";
  // Zone de saisie de l'URL
  private Display myDisplay = null;
  private Form mainScreen;
  private TextField myRequest;
  // Zone d'affichage de l'en-tte
  private Form resultScreen;
  private StringItem myResult;
  // Commande "envoie"
  Command commandSend = new Command("Envoi", Command.OK, 1);
  // Commande "retour"
  Command commandBack = new Command("Retour", Command.OK, 1);

  public HttpPost(){
    // Initialisation de l'interface utilisateur
    myDisplay = Display.getDisplay(this);
    mainScreen = new Form("Entrez une URL :");
    myRequest = new TextField(null, myURL, 100, TextField.URL);
    mainScreen.append(myRequest);
    mainScreen.addCommand(commandSend);
    mainScreen.setCommandListener(this);
  }

  public void startApp() {
    myDisplay.setCurrent(mainScreen);
  }

  public void pauseApp() {
  }

  public void destroyApp(boolean unconditional) {
  }

  public void commandAction(Command c, Displayable s) {
    // L'utilisateur a cliqu sur la commande "envoie"
    if (c == commandSend) {
      // Rcupration de l'URL saisie
      String strURL = myRequest.getString();
      // Envoi d'une requte POST au serveur HTTP
      String strResult = sendPostRequest(strURL);
      // Affichage du contenu de la page reue du serveur HTTP
      resultScreen = new Form("Rsultat:");
      myResult = new StringItem(null, strResult);
      resultScreen.append(myResult);
      resultScreen.addCommand(commandBack);
      resultScreen.setCommandListener(this);
      myDisplay.setCurrent(resultScreen);
    } else if (c == commandBack) {
      // On reprend au dbut
      myRequest.setString(myURL);
      myDisplay.setCurrent(mainScreen); 
    }
  }

  // Envoiu d'une requte POST au serveur HTTP
  public String sendPostRequest(String strURL) {
    HttpConnection hc = null;
    DataInputStream dis = null;
    DataOutputStream dos = null;
    String myMessage = "";
    // Spcification de la chane query
    String strRequest = "nom=toto";
    try {
      // Ouverture de la connexion HTTP avec le serveur HTTP
      // en lecture et en criture
      hc = (HttpConnection) Connector.open(strURL, Connector.READ_WRITE);
      // Mise en place de la mthode de requte POST
      hc.setRequestMethod(HttpConnection.POST);
      // Rcupration du flux en sortie pour l'envoi de la chane query
      dos = hc.openDataOutputStream();
      byte[] request_body = strRequest.getBytes();
      // Envoi de la chane query au serveur HTTP
      for (int i = 0; i < request_body.length; i++) {
        dos.writeByte(request_body[i]);
      }
      dos.flush();
      // Rcupration du flux en entre pour la rception de la rponse HTTP
      dis = new DataInputStream(hc.openInputStream());
      // Lecture de la rponse du serveur HTTP caractre par caractre
      int ch;
      while ((ch = dis.read()) != -1) {
        myMessage = myMessage + (char) ch;
      }
    } catch (IOException ioe) {
      myMessage = "ERREUR";
    } finally {
      // Libration des flux d'e/s et de la connexion HTTP
      try {
        if (hc != null) hc.close();
      } catch (IOException ignored) {
      }
      try {
        if (dis != null) dis.close();
      } catch (IOException ignored) {
      }
      try {
        if (dos != null) dos.close();
      } catch (IOException ignored) {
      }
    }
    return myMessage;
  }
}
